load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  

begin
  nlat  = 3600
  mlon  = 7200

  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  fili  = "MOD15A2_GEO_2000001.nc"
  a  = addfile(diri+fili,"r")

  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  filo  = "LAI_2000001_3.nc"
  c = addfile(diro+filo,"c")

  y = a->Lai_0_05deg

  y@_FillValue = inttobyte(253)
  y@_FillValue = inttobyte(255)

  x = byte2flt(y)
  
; x@_FillValue = -17281                      ; orig fill    
  x@_FillValue =  1.e+36                     ; new fill

  lat  = latGlobeFo(nlat, "lat", "latitude", "degrees_north")
  lat  = (/ lat(::-1) /)                     ; make N->S
  lon  = lonGlobeFo(mlon, "lon", "longitude", "degrees_east")
  lon  = (/ lon - 180. /) ; subtract 180 from all values 
  lon&lon = lon           ; update coordinates

  x!0  = "lat"
  x!1  = "lon"
  x&lat=  lat
  x&lon=  lon

  c->LAI  = x 
end

