load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  

begin 
;----------------------------------------------------------
  year = "2004"
  
  nlat  = 3600
  mlon  = 7200
  month_in_year = 12
;----------------------------------------------------------
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  filo  = "MOD15A2_LAI_" + year + "_monthly.nc"
  c = addfile(diro+filo,"c")
  filedimdef(c,"time",-1,True)

  day = (/"001","009","017","025","033","041","049","057","065","073", \
          "081","089","097","105","113","121","129","137","145","153", \
          "161","169","177","185","193","201","209","217","225","233", \
          "241","249","257","265","273","281","289","297","305","313", \
          "321","329","337","345","353","361"/)

  file_index_L = (/0,3,7 ,11,15,18,22,26,30,34,38,41/)
  file_index_R = (/3,7,11,14,18,22,26,30,34,37,41,45/)
  scale_L      = (/8,1,5,6,8,1,3,4,5,7,8,2/)
  scale_R      = (/7,3,2,8,7,5,4,3,1,8,6,5/)

;  dayI = stringtointeger(day)
;  print (dayI)

  x = new((/12,nlat,mlon/),float)
  x = 0.
  x@_FillValue =  1.e+36

 do m = 0,month_in_year-1
    nday = 0                                   ; number of day in a month
 do n = file_index_L(m),file_index_R(m)
    fili  = "MOD15A2_GEO_" + year + day(n) + ".hdf"
    print (fili)
    a = addfile(diri+fili,"r")
    y = a->Lai_0_05deg

    y@_FillValue = inttobyte(253)              ; special missing value? 
    y@_FillValue = inttobyte(255)              ; missing value 

    z = byte2flt(y)
          
    z@_FillValue =  1.e+36

;   weighted by day, data is 8-day average                 
    scale = 8              
    if (n .eq. file_index_L(m)) then
       scale = scale_L(m)
    end if
    if (n .eq. file_index_R(m)) then
       scale = scale_R(m)
    end if

    nday = nday + scale

    x(m,:,:) = where(ismissing(z),1.e+36,x(m,:,:)+z(:,:)*scale)

    delete (a)
    delete (y)
    delete (z)
 end do
    x(m,:,:) = where(ismissing(x(m,:,:)),1.e+36,x(m,:,:)/nday)
    print (nday)
    print (min(x) + "/" + max(x))
 end do

  lat  = latGlobeFo(nlat, "lat", "latitude", "degrees_north")
  lat  = (/ lat(::-1) /)                     ; make N->S
  lon  = lonGlobeFo(mlon, "lon", "longitude", "degrees_east")
  lon  = (/ lon - 180. /) ; subtract 180 from all values 
  lon&lon = lon           ; update coordinates

  x!0  = "time"
  x!1  = "lat"
  x!2  = "lon"
  x&time= ispan(1,month_in_year,1)
  x&lat=  lat
  x&lon=  lon
  x@units      = "none"
  x@long_name  = "Leaf Area Index"

  c->LAI  = x 
end

