load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  

begin 
;----------------------------------------------------------
  year_start = 2000
  year_end   = 2005
;----------------------------------------------------------
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/lai/ob/"

  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/lai/ob/"
  filo1 = "LAI_"+year_start+"-"+year_end+"_MONS_T31_3.nc"
  filo2 = "LAI_"+year_start+"-"+year_end+"_ANN_T31_3.nc"
  c = addfile(diro+filo1,"c")
  d = addfile(diro+filo2,"c")

  nyear = year_end - year_start + 1

  files  = new((/nyear/),"string")

  do n = year_start,year_end
     i = n - year_start
     files(i)= diri + "LAI_" + n + "_monthly_T31.nc"
  end do
  print (files)  

  file_list = addfiles(files,"r")
  ListSetType(file_list,"join")
  x = addfiles_GetVar(file_list, files, "LAI")
  printVarSummary (x)
  x@_FillValue = 1.e+36

  y = dim_avg_Wrap(x(time|:,lat|:,lon|:,case|:))
  printVarSummary (y)
  y@_FillValue = 1.e+36
 
  c->LAI  = y

  z = dim_avg_Wrap(y(lat|:,lon|:,time|:))
  printVarSummary (z)
  z@_FillValue = 1.e+36
  
  d->LAI  = z     
end

