;************************************************
;    Read ascii, Write nc
;    output: lat: N->S     lon: -180W->180E 
;    class 8 split into class  8 = woody savanna (S. Hem.)
;                             18 = woody savanna (N. Hem.)                   
;    class 8 split into class  9 =       savanna (S. Hem.)
;                             19 =       savanna (N. Hem.)     
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  
;************************************************
begin
;---------------------------------------------------
; final data
  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/lai/"
  filo  = "land_class_0.25deg_new.nc"
  c = addfile(diro+filo,"c")
; filedimdef(c,"time",-1,True) 
       
  nlat  = 180*4 
  nlon  = 360*4
  
  t        = new((/nlat,nlon/),integer)
  lon      = new((/nlon/),float)
  lat      = new((/nlat/),float)
;---------------------------------------------------
; input data
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/lai/modis_landcover_qdeg/"
  fili = "modis_landcover_class_qd.asc"                    
  b = diri+fili
  
  lat  = latGlobeFo(nlat, "lat", "latitude", "degrees_north")
  lat  = (/ lat(::-1) /)                     ; make N->S
  lon  = lonGlobeFo(nlon, "lon", "longitude", "degrees_east")
  lon  = (/ lon - 180. /) ; subtract 180 from all values 
  lon&lon = lon           ; update coordinates
  lat&lat = lat           ; update coordinates

;=============================
;  name dimensions of t and assign coordinate variables
;============================  
  t!0    = "lat"
  t!1    = "lon"
  t&lat  = lat
  t&lon  = lon
  t@long_name = "landcover class"
  t@units     = ""
  t@_FillValue= -9999         
  t@missing_value= -9999         

  t = asciiread(b,(/nlat,nlon/),"integer")

  nlat = dimsizes(lat)
  ny2  = nlat/2

  do j = 0,ny2-1
     t(j,:) = where((t(j,:) .eq. 8),18,t(j,:))
     t(j,:) = where((t(j,:) .eq. 9),19,t(j,:)) 
  end do
 
  c->LAND_CLASS  = t
  c->lat  = lat
  c->lon  = lon

  print (min(t) + "/" + max(t))
end
