load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  

begin 
;----------------------------------------------------------
  year_start = 2000
  year_end   = 2005
;----------------------------------------------------------
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  filo1 = "MOD15A2_LAI_"+year_start+"-"+year_end+"_ensemble.nc"
  filo2 = "MOD15A2_LAI_"+year_start+"-"+year_end+"_mean.nc"
  c = addfile(diro+filo1,"c")
  d = addfile(diro+filo2,"c")

  nyear = year_end - year_start + 1

  files  = new((/nyear/),"string")

  do n = year_start,year_end
     i = n - year_start
;    files(i)= diri + "MOD15A2_LAI_" + n + "_monthly.nc"
     files(i)= diri + "MOD15A2_LAI_" + n + "_monthly_T42.nc"
  end do
  print (files)  

  file_list = addfiles(files,"r")
  ListSetType(file_list,"join")
  x = addfiles_GetVar(file_list, files, "LAI")
  printVarSummary (x)

  y = addfiles_GetVar(file_list, files, "time")
  time = y(0,:)
  delete(time@case)
  delete(y)
  printVarSummary (time)

  y = addfiles_GetVar(file_list, files, "lat")
  lat = y(0,:)
  delete(lat@case)
  delete(y)
  printVarSummary (lat)

  y = addfiles_GetVar(file_list, files, "lon")
  lon = y(0,:)
  delete(lon@case)
  delete(y)
  printVarSummary (lon)

  x!0  = "case"
  x!1  = "time"
  x!2  = "lat"
  x!3  = "lon"

  y = dim_avg(x(time|:,lat|:,lon|:,case|:))

  y!0  = "time"
  y!1  = "lat"
  y!2  = "lon"
  y&time = time
  y&lat  = lat
  y&lon  = lon
  y@units     = "none"
  y@long_name = "Leaf Area Index"
  printVarSummary (y)

  c->LAI  = y

  z = dim_avg(y(lat|:,lon|:,time|:))

  z!0  = "lat"
  z!1  = "lon"
  z&lat  = lat
  z&lon  = lon
  z@units     = "none"
  z@long_name = "Leaf Area Index"
  printVarSummary (z)
  
  d->LAI  = z     
end

