; ***********************************************
; xy_4.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
;************************************************
begin
;************************************************
; read in data: observed
;************************************************
;g     = addfile ("data.81.nc","r")
 g     = addfile ("data.933.nc","r")
 a     = g->TNPP_C
;a     = g->ANPP_C
;a     = g->BNPP_C  
 xo    = g->LONG_DD 
 yo    = g->LAT_DD   

 a@long_name = "TNPP_C (gC/m2/year)"
;a@long_name = "ANPP_C (gC/m2/year)"
;a@long_name = "BNPP_C (gC/m2/year)"

;print (xo)
 nx = dimsizes(xo)
 do i= 0,nx-1
    if (xo(i) .lt. 0.) then
        xo(i) = xo(i)+ 360.
    end if
 end do
;print (xo)

;************************************************
; read in data: model
;************************************************ 
 f     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
;f     = addfile ("i01.04casa_1605-1629_ANN_climo.nc","r")

 b     = f->NPP
;b     = f->AGNPP
;b     = f->BGNPP    
 xi    = f->lon      
 yi    = f->lat

 sec_to_year = 86400.*365.

 bo = linint2_points(xi,yi,b,True,xo,yo,0) * sec_to_year
;print (bo)

 bo@long_name = "NPP (gC/m2/year)"     
;bo@long_name = "AGNPP (gC/m2/year)"
;bo@long_name = "BGNPP (gC/m2/year)"

;************************************************
; plotting parameters
;************************************************
;wks   = gsn_open_wks ("ps","xy")                 ; open workstation
 wks   = gsn_open_wks ("png","xy")

 res                   = True                     ; plot mods desired
;res@tiMainString      = "Model_i01.03cn vs Observed 81"    ; add title
 res@tiMainString      = "Model_i01.03cn vs Observed 933"   ; add title
;res@tiMainString      = "Model_i01.04casa vs Observed 81"  ; add title
;res@tiMainString      = "Model_i01.04casa vs Observed 933" ; add title
 res@xyMarkLineModes   = "Markers"                ; choose which have markers
 res@xyMarkers         =  16                      ; choose type of marker  
 res@xyMarkerColor     = "red"                    ; Marker color
 res@xyMarkerSizeF     = 0.01                     ; Marker size (default 0.01)

 res@tmLabelAutoStride = True                     ; nice tick mark labels

 plot  = gsn_csm_xy (wks,a,bo,res) ; create plot

;************************************************
; now create our own markers using NhlNewMarker 
; available since ncl version 4.2.0.a030
;************************************************
; this example will create filled squares. You will have to play with
; the numbers a but to get the size and shape you desire. On the
; documentation page for NhlNewMarker, there is a table of values for
; the current marker set, to give you an idea of where to start.

;  res@xyMarkerColor = "blue"
;  res@tiMainString  = "Make your own marker"
;  res@xyMarkers     = NhlNewMarker(wks, "^", 19, 0.0, 0.0, 1.3125, 1.5, 0.0)
;  plot              = gsn_csm_xy (wks,a,bo,res) 

end
