; ***********************************************
; xy_4.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
;************************************************
begin
;************************************************
; read in data
;************************************************
 g     = addfile ("data.81.nc","r")
 a     = g->SITE_ID  
 xo    = g->LONG_DD  
 yo    = g->LAT_DD
;c     = g->TNPP_C
;c     = g->ANPP_C
 c     = g->BNPP_C   

 print (xo)
 nx = dimsizes(xo)
 do i= 0,nx-1
    if (xo(i) .lt. 0.) then
        xo(i) = xo(i)+ 360.
    end if
 end do
 print (xo)

 a@long_name = "SITE_ID"
 
 f     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
;f     = addfile ("i01.04casa_1605-1629_ANN_climo.nc","r")
;b     = f->NPP
;b     = f->AGNPP
 b     = f->BGNPP    
 xi    = f->lon     
 yi    = f->lat      

 sec_to_year = 86400.*365.

 bo = linint2_points(xi,yi,b,True,xo,yo,0) * sec_to_year
;print (bo)

 bo@long_name = "NPP (gC/m2/year)"
 
 ccr = esccr(bo,c,0)

 print (ccr)

end
