; ***********************************************
; xy_4.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin
;************************************************
; read in data
;************************************************
 g     = addfile ("Npp_T42_mean.nc","r")
 c     = g->NPP  
 u     = ndtooned(c)

;f     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
 f     = addfile ("i01.04casa_1605-1629_ANN_climo.nc","r")
 b     = f->NPP      
 v     = ndtooned(b)

 sec_to_year = 86400.*365.
 v = v * sec_to_year

 good = ind(.not.ismissing(u) .and. .not.ismissing(v))
 uu = u(good)
 nx = dimsizes(uu)
;print (nx)

 do i = 0,nx-1
    if (uu(i) .lt. 1.) then
       uu(i) =10.
    end if
 end do

 ccr = esccr(uu,v(good),0)
 print (ccr)
;print (uu)
 bias = sum(((v(good)-uu)/uu)^2)
 print (bias)
 M    = 1.- sqrt(bias/nx)
 print (M)

end
