; ***********************************************
; xy_4.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin
;************************************************
; read in observed data
;************************************************
 f     = addfile ("Npp_T42_mean.nc","r")
 y     = f->NPP
;************************************************
; read in model data
;************************************************
 g     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
;g     = addfile ("i01.04casa_1605-1629_ANN_climo.nc","r")
 x     = g->NPP

 delta = 0.00000000001
 x0    = x(0,:,:)
 y = where(ismissing(y).and.(ismissing(x0).or.(x0.lt.delta)),0.,y)

 p     = zonalAve(y)        

 sec_to_year = 86400.*365.
 x0 = x0 * sec_to_year
 q = zonalAve(x0)

 good = ind(p .ne. 0.)
 u = p(good)
 v = q(good)
 
 ccr = esccr(u,v,0)
 print (ccr)
 bias = sum(((v-u)/u)^2)
 print (bias)
 M    = 1.- sqrt(bias/dimsizes(u))
 print (M)

end
