; ***********************************************
; xy_1.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  
;************************************************
begin
;************************************************
; read in data
;************************************************
;f     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
 f     = addfile ("i01.04casa_1605-1629_ANN_climo.nc","r")
 u     = f->NPP 
 v     = zonalAve(u)

 nsec_per_year = 60*60*24*365

 v = v * nsec_per_year

 v@long_name = "NPP (gC/m2/year)"        
;************************************************
; plotting parameters
;************************************************
 wks   = gsn_open_wks ("png","xy")                

 res                  = True                     
;res@tiMainString     = "Model i01.03cn"         
 res@tiMainString     = "Model i01.04casa"         

 plot  = gsn_csm_xy (wks,v&lat,v(0,:),res) 
end