; ***********************************************
; xy_1.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  
;************************************************
begin
;************************************************
; read in data
;************************************************
 f     = addfile ("Npp_T42_mean.nc","r")
 u     = f->NPP
;************************************************
; read in model data
;************************************************
 g     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
 x     = g->NPP
 lat   = g->lat
 lon   = g->lon

 delta = 0.00000000001
 x0    = x(0,:,:)
 u = where(ismissing(u).and.(ismissing(x0).or.(x0.lt.delta)),0.,u)

; do j = 0,dimsizes(lat)-1
; do i = 0,dimsizes(lon)-1     
;    print(u(j,i))
;    print(x(0,j,i))
;    if (ismissing(u(j,i)) .and. (ismissing(x(0,j,i)).or. \
;                                 x(0,j,i) .lt. 0.00000000001)) then
;       u(j,i) = 0.
;    end if
; end do
; end do

 v     = zonalAve(u)

 v@long_name = "NPP (gC/m2/year)"        
;************************************************
; plotting parameters
;************************************************
 wks   = gsn_open_wks ("png","xy")                

 res                  = True                              
 res@tiMainString     = "Observed MODIS MOD 17"         

 plot  = gsn_csm_xy (wks,v&lat,v,res) 
end