; ***********************************************
; xy_4.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin
;************************************************
; read in data: observed
;************************************************
 diri  = "/fis/cgd/cseg/people/jeff/clamp_data/co2/"
 fili  = "co2_globalView_222.nc"
 g     = addfile (diri+fili,"r")
 a     = g->CO2_SEAS  
 lon   = g->LON 
 lat   = g->LAT 
 
 ncase = dimsizes(lat)
 print (ncase)

 lat_tmp = lat
 lat_tmp@_FillValue = 1.e+36
 
 do n = 0,ncase-1
    if (.not. ismissing(lat_tmp(n))) then 
       indexes = ind(lat(n) .eq. lat .and. lon(n) .eq. lon)
       if (dimsizes(indexes) .gt. 1) then
          lat_tmp(indexes(1:)) = lat_tmp@_FillValue
       end if
       delete (indexes)
    end if
 end do

 indexes = ind(.not. ismissing(lat_tmp))
 print (indexes)
 
 lat_new = lat(indexes)
 lon_new = lon(indexes)
 print (lat_new +"/"+lon_new)

exit

end
