;************************************************
;    Read ascii, Write nc                         
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"   
;************************************************
begin
; final output
  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/co2/"
  filo =  "co2_globalView_98.nc"
  c = addfile(diro+filo,"c")
  filedimdef(c,"time",-1,True)

; input ascii files
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/co2/globalView-C4Mip/seas/"
  b = (/ \
"aia005_02D2", \
"alt_01D0", \
"ams_01D0", \
"asc_01D0", \
"ask_01D0", \
"avi_01D0", \
"azr_01D0", \
"bal_01D1", \
"bgu_11D0", \
"bhd_15C0", \
"bme_01D0", \
"bmw_01D0", \
"brw_01C0", \
"bsc_01D0", \
"car030_01D2", \
"cba_01D0", \
"cfa_02D0", \
"cgo_01D0", \
"chr_01D0", \
"cmn_17C0", \
"cmo_01D0", \
"coi_20C0", \
"cpt_36C0", \
"cri_02D0", \
"crz_01D0", \
"csj_06D0", \
"daa_02D0", \
"eic_01D0", \
"esp_02D0", \
"frd040_06C3", \
"gmi_01D0", \
"goz_01D0", \
"gsn_24D0", \
"haa005_01D2", \
"hat_20C0", \
"hba_01D0", \
"hfm005_01D2", \
"hun010_35C3", \
"ice_01D0", \
"itn051_01C3", \
"izo_01D0", \
"jbn_29C0", \
"key_01D0", \
"kum_01D0", \
"kzd_01D0", \
"kzm_01D0", \
"lef011_01C3", \
"ljo_04D0", \
"lmp_28D0", \
"maa_02D0", \
"mbc_01D0", \
"mhd_01D0", \
"mid_01D0", \
"mlo_01C0", \
"mnm_19C0", \
"mqa_02D0", \
"nwr_01D0", \
"obs023_06C3", \
"opw_01D0", \
"orl005_11D2", \
"palcbc_30C0", \
"pdm_11D0", \
"pfa015_01D2", \
"poc000_01D1", \
"pocn05_01D1", \
"pocs05_01D1", \
"prs_21C0", \
"psa_01D0", \
"rpb_01D0", \
"rta005_01D2", \
"ryo_19C0", \
"sbl_06C0", \
"sch_23C0", \
"scsn03_01D1", \
"sey_01D0", \
"shm_01D0", \
"sis_02D0", \
"smo_01C0", \
"spo_01C0", \
"stm_01D0", \
"stp_12D0", \
"sum_01D0", \
"syo_01D0", \
"tap_01D0", \
"tdf_01D0", \
"trm_11D0", \
"uta_01D0", \
"uum_01D0", \
"wes_23C0", \
"wis_01D0", \
"wkt009_01C3", \
"wlg_01D0", \
"wpo000_10D2", \
"wpon05_10D2", \
"wpos05_10D2", \
"yon_19C0", \
"zep_01D0", \
"zot005_45D2"/) 

  ntime = 12
  ncase = dimsizes(b)
  print (ncase)

  mean = new((/ncase,ntime/),float)
  lat  = new((/ncase/),float)
  lon  = new((/ncase/),float)
  elev = new((/ncase/),float) 

  do n = 0,dimsizes(b)-1
     fili = diri + b(n) + "_seas.co2"
     print (fili)
                    
     ncol1 = 4
     data1 = readAsciiTable(fili, ncol1, "float", (/10,17/))

     lat(n)  = data1(0,0)
     lon(n)  = data1(0,1)
     elev(n) = data1(0,2)

     ncol2 = 5
     data2 = readAsciiTable(fili, ncol2, "float", 16)

     mean(n,:) = data2(:,1)
  end do

; mean!0  = "case"
; mean!1  = "time"
; mean&case= ispan(1,ncase,1)
; mean&time= ispan(1,ntime,1)
  mean@units      = "u mol/mol"
  mean@long_name  = "CO2 GlobalView seasonal"

; lat!0     = "case"
; lon!0     = "case"
; elev!0    = "case"
; lat&case  = mean&case
; lon&case  = mean&case
; elev&case = mean&case

  lat@units      = "degrees_north"
  lat@long_name  = "Latitude"
  lon@units      = "degrees_ease"
  lon@long_name  = "Longitude"        
  elev@units      = "m"
  elev@long_name  = "Elevation above sea level"
  b@units      = ""
  b@long_name  = "Station"

  print (lat)
  print (mean)
  print (b)
  
  c->LAT       = lat
  c->LON       = lon
  c->ELEV      = elev
  c->CO2_SEAS  = mean
  c->STATION   = stringtochar(b)  
end
