;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
;************************************************
begin
;************************************************
; read in model data
;************************************************
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/model/"
  fili  = "b30.061m_401_425_ANN_climo.nc"

  g     = addfile(diri+fili,"r")
  x     = g->CO2
  xdim  = dimsizes(x)
  nlev  = xdim(1)
  y0    = x(0,0,:,:)
  
; get the co2 at the lowest level
  y0    = x(0,nlev-1,:,:)

; change to unit of observed (u mol/mol)
; Model_units [=] kgCO2 / kgDryAir
; 28.966 = molecular weight of dry air
; 44.       = molecular weight of CO2
; u mol = 1e-6 mol

  factor = (28.966/44.) * 1e6
  y0     = y0 * factor

  y0@_FillValue = 1.e36
  y0@units      = "u mol/mol"
; y0 = where(y0 .lt. 287.,y0@_FillValue,y0)
  print (min(y0)+"/"+max(y0))

;************************************************
; create default plot
;************************************************

  wks = gsn_open_wks("ps","xy")              ; open a ps file
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors      = True            ; use full colormap
; res@cnFillMode          = "RasterFill"     ; Turn on raster color
; res@lbLabelAutoStride   = True
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
  res@tiMainString        = "Model b30.061m 401-425"

  res@gsnSpreadColors     = True             ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"  ; Manual contour invtervals
  res@cnMinLevelValF       = 286.            ; Min level
  res@cnMaxLevelValF       = 310.            ; Max level
  res@cnLevelSpacingF      = 2.              ; interval

  plot = gsn_csm_contour_map_ce(wks,y0,res)         ; for model
  system("convert xy.ps xy.png")
end