; ***********************************************
; combine 19.metric_plot.ncl and 24.lines.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl.test"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl.test"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;load "/fis/cgd/cseg/people/jeff/clamp/co2/metrics_table.ncl"
;************************************************
begin

  plot_type ="ps"
  plot_name = "table_zone" 
  wks = gsn_open_wks (plot_type,plot_name)   ; open workstation
;--------------------------------------------------------------
; for zone table 

;**********************************
; table header name
  table_header_name = "Zone" 

; column (not including header column)
  col_header_zone = (/"Stations","Amplitude Ratio", \
                      "Correlation Coef","M score","Combined Score"/)
  ncol_zone       = dimsizes(col_header_zone ) 

; row (not including header row)
  row_header_zone = (/"60N-90N","30N-60N","EQ-30N","90S-EQ","Total"/)  
  nrow_zone       = dimsizes(row_header_zone)                  

; arrays to be passed to table. 
  value_zone = new ((/nrow_zone, ncol_zone/),string ) 
;**********************************

  table_length_zone = 0.4 

; Table header
  ncr1  = (/1,1/)               ; 1 row, 1 column
  x1    = (/0.005,0.15/)        ; Start and end X
  y1    = (/0.900,0.995/)       ; Start and end Y
  text1 = table_header_name
  res1               = True
  res1@txFontHeightF = 0.03
  res1@gsFillColor   = "CornFlowerBlue"

; Column header (equally space in x2)
  ncr2  = (/1,ncol_zone/)         ; 1 rows, 5 columns
  x2    = (/x1(1),0.995/)          ; start from end of x1
  y2    = y1                      ; same as y1
  text2 = col_header_zone
  res2               = True
  res2@txFontHeightF = 0.015
  res2@gsFillColor   = "Gray"

; Row header (equally space in y2)
  ncr3  = (/nrow_zone,1/)         ; 5 rows, 1 columns
  x3    = x1                      ; same as x1
  y3    = (/1.0-table_length_zone,0.900/) ; end at start of y1
  text3 = row_header_zone
  res3               = True
  res3@txFontHeightF = 0.02
  res3@gsFillColor   = "Gray"

; Main table body
  ncr4  = (/nrow_zone,ncol_zone/) ; 5 rows, 5 columns
  x4    = x2                      ; Start and end x
  y4    = y3                      ; Start and end Y
  text4 = new((/nrow_zone,ncol_zone/),string)

  color_fill4      = new((/nrow_zone,ncol_zone/),string)
  color_fill4      = "white"
  color_fill4(:,ncol_zone-1) = "grey"

  res4               = True       ; Set up resource list
; res4@gsnDebug      = True       ; Useful to print NDC row,col values used.
  res4@txFontHeightF = 0.02
  res4@gsFillColor   = color_fill4

  delete (color_fill4)

;**************************************************
; plot zone table
;**************************************************
 
  text4 = sprintf("%5.2f", 0.9999 )

  gsn_table(wks,ncr1,x1,y1,text1,res1)
  gsn_table(wks,ncr2,x2,y2,text2,res2)
  gsn_table(wks,ncr3,x3,y3,text3,res3)
  gsn_table(wks,ncr4,x4,y4,text4,res4) 

  frame(wks)

end
