;************************************************
;    Read ascii, Write nc
;    output: lat: N->S     lon: -180W->180E                         
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  
;************************************************
begin

; output

  model_name = "i01.41cn"
  
  ;diro  = "/ptmp/jeff/"
  diro  = "/lustre/wolf-ddn/scratch/hof/cases1/i01.41cn_out/"
  filo  = model_name + "_ameriflux_2076-2100_monthly.nc"
  c = addfile(diro+filo,"c")
  filedimdef(c,"year",-1,True) 

; input data

  nlat = 96
  nlon = 144

  year_start = 2076
  year_end   = 2100

  nyear  = year_end - year_start + 1
  nmonth = 12
  
  data1  = new((/nyear,nmonth,nlat,nlon/),float)
  data2  = new((/nyear,nmonth,nlat,nlon/),float)
  data3  = new((/nyear,nmonth,nlat,nlon/),float)
  ;data4  = new((/nyear,nmonth,nlat,nlon/),float)
  ;data5  = new((/nyear,nmonth,nlat,nlon/),float)
  data6  = new((/nyear,nmonth,nlat,nlon/),float)
  data7  = new((/nyear,nmonth,nlat,nlon/),float)
  data8  = new((/nyear,nmonth,nlat,nlon/),float)
  data9  = new((/nyear,nmonth,nlat,nlon/),float)
  data10 = new((/nyear,nmonth,nlat,nlon/),float)
  date   = new((/nyear,nmonth/),integer)

;  name dimensions and assign coordinate variables

  data1!0    ="year"
  data1!1    ="month"
  data1!2    = "lat"
  data1!3    = "lon"

  data2!0    ="year"
  data2!1    ="month"
  data2!2    = "lat"
  data2!3    = "lon"

  data3!0    ="year"
  data3!1    ="month"
  data3!2    = "lat"
  data3!3    = "lon"

  ;data4!0    ="year"
  ;data4!1    ="month"
  ;data4!2    = "lat"
  ;data4!3    = "lon"

  ;data5!0    ="year"
  ;data5!1    ="month"
  ;data5!2    = "lat"
  ;data5!3    = "lon"

  data6!0    ="year"
  data6!1    ="month"
  data6!2    = "lat"
  data6!3    = "lon"

  data7!0    ="year"
  data7!1    ="month"
  data7!2    = "lat"
  data7!3    = "lon"

  data8!0    ="year"
  data8!1    ="month"
  data8!2    = "lat"
  data8!3    = "lon"

  data9!0    ="year"
  data9!1    ="month"
  data9!2    = "lat"
  data9!3    = "lon"

  data10!0    ="year"
  data10!1    ="month"
  data10!2    = "lat"
  data10!3    = "lon"

  date!0    ="year"
  date!1    ="month"
  date@long_name  = "date: yyyymm"

; input dir
  diri  = "/lustre/wolf-ddn/scratch/hof/cases1/"+model_name+"/"

  do m = 0,nyear-1
     year = year_start + m
  do n = 0,nmonth-1
     nn = n+1
     date(m,n) = year*100 +nn 
     
;    input file
     if (nn .ge. 10) then
        fili = model_name+".clm2.h0."+year+"-"+nn+".nc"
     else
        fili = model_name+".clm2.h0."+year+"-0"+nn+".nc"
     end if

     print (fili)

     g = addfile (diri+fili,"r")

     b = g->NEE
     data1(m,n,:,:) = (/b(0,:,:)/)
     data1@long_name  = b@long_name
     data1@units      = b@units
     data1@_FillValue = b@_FillValue
     delete (b)

     b = g->GPP
     data2(m,n,:,:) = (/b(0,:,:)/)
     data2@long_name  = b@long_name
     data2@units      = b@units
     data2@_FillValue = b@_FillValue
     delete (b)

     b = g->ER
     data3(m,n,:,:) = (/b(0,:,:)/)
     data3@long_name  = b@long_name
     data3@units      = b@units
     data3@_FillValue = b@_FillValue
     delete (b)

     ;b = g->NETRAD
     ;data4(m,n,:,:) = (/b(0,:,:)/)
     ;data4@long_name  = b@long_name
     ;data4@units      = b@units
     ;data4@_FillValue = b@_FillValue
     ;delete (b)

     ;b = g->LATENT
     ;data5(m,n,:,:) = (/b(0,:,:)/)
     ;data5@long_name  = b@long_name
     ;data5@units      = b@units
     ;data5@_FillValue = b@_FillValue
     ;delete (b)

     b = g->FSH
     data6(m,n,:,:) = (/b(0,:,:)/)
     data6@long_name  = b@long_name
     data6@units      = b@units
     data6@_FillValue = b@_FillValue
     delete (b)

     b = g->FSDS
     data7(m,n,:,:) = (/b(0,:,:)/)
     data7@long_name  = b@long_name
     data7@units      = b@units
     data7@_FillValue = b@_FillValue
     delete (b)

     b = g->FCEV
     data8(m,n,:,:) = (/b(0,:,:)/)
     data8@long_name  = b@long_name
     data8@units      = b@units
     data8@_FillValue = b@_FillValue
     delete (b)

     b = g->FCTR
     data9(m,n,:,:) = (/b(0,:,:)/)
     data9@long_name  = b@long_name
     data9@units      = b@units
     data9@_FillValue = b@_FillValue
     delete (b)

     b = g->FGEV
     data10(m,n,:,:) = (/b(0,:,:)/)
     data10@long_name  = b@long_name
     data10@units      = b@units
     data10@_FillValue = b@_FillValue
     delete (b)

  end do
  end do
         
  c->NEE = data1
  c->GPP = data2
  c->ER  = data3
  ;c->NETRAD = data4
  ;c->LATENT = data5
  c->FSH    = data6
  c->FSDS   = data7
  c->FCEV   = data8
  c->FCTR   = data9
  c->FGEV   = data10
  c->date   = date
  c->area   = g->area

  print (date)

end
