; ***********************************************
; xy_4.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin
;************************************************
; read in data: observed
;************************************************
 diri  = "/fis/cgd/cseg/people/jeff/clamp_data/co2/"
 fili  = "co2_globalView_222.nc"
 g     = addfile (diri+fili,"r")
 val   = g->CO2_SEAS  
 lon   = g->LON 
 lat   = g->LAT 
 delete (g)
 
 ncase = dimsizes(lat)
;print (ncase)

;**************************************************************
; get only the lowest level at each station 
;**************************************************************
 lat_tmp = lat
 lat_tmp@_FillValue = 1.e+36
 
 do n = 0,ncase-1
    if (.not. ismissing(lat_tmp(n))) then 
       indexes = ind(lat(n) .eq. lat .and. lon(n) .eq. lon)
       if (dimsizes(indexes) .gt. 1) then
          lat_tmp(indexes(1:)) = lat_tmp@_FillValue
       end if
       delete (indexes)
    end if
 end do

 indexes = ind(.not. ismissing(lat_tmp))
;print (indexes)
 
 lat_ob = lat(indexes)
 lon_ob = lon(indexes)
 val_ob = val(indexes,:)
;printVarSummary (val_ob)
;print (lat_ob +"/"+lon_ob)

;************************************************
; read in model data
;************************************************
  diri2 = "/fis/cgd/cseg/people/jeff/clamp_data/model/"
  fili2 = "b30.061m_401_425_MONS_climo.nc"

  g     = addfile(diri2+fili2,"r")
  x     = g->CO2
  xi    = g->lon
  yi    = g->lat
  xdim  = dimsizes(x)
  nlev  = xdim(1)
  y     = x(:,0,:,:)
; printVarSummary (y)
  
; get the co2 at the lowest level
  y     = x(:,nlev-1,:,:)

; change to unit of observed (u mol/mol)
; Model_units [=] kgCO2 / kgDryAir
; 28.966 = molecular weight of dry air
; 44.       = molecular weight of CO2
; u mol = 1e-6 mol

  factor = (28.966/44.) * 1e6
  y      = y * factor

  y@_FillValue = 1.e36
  y@units      = "u mol/mol"
; y = where(y0 .lt. 287.,y@_FillValue,y)
; printVarSummary (y)
; print (min(y)+"/"+max(y))

; interpolate into observed station

  yo = linint2_points_Wrap(xi,yi,y,True,lon_ob,lat_ob,0)

  val_model = val_ob
  val_model = yo(pts|:,time|:)
  printVarSummary (val_model)
  print (min(val_model)+"/"+max(val_model))

; remove annual mean
  val_model = val_model - conform(val_model,dim_avg(val_model),0)
  print (min(val_model)+"/"+max(val_model))
exit
;**************************************************************
; get stations of 60N-90N
;**************************************************************

 ind_1 = ind(lat_new .gt. 60.)
 print (ind_1)
 print (lat_new(ind_1)+"/"+lon_new(ind_1))
 print (val_new(ind_1(0),:))
exit

end
