; ***********************************************
; zonal average plot
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin
;************************************************
; read in observed data
;************************************************
 g     = addfile ("Npp_0.05deg_mean.nc","r")
 bi    = g->NPP   
 xi    = g->lon 
 yi    = g->lat
 yi    = (/ yi(::-1) /)
 bi    =  (/ bi(::-1,:) /)
 b2    = bi
 x2    = xi   
 
 nx = dimsizes(xi)
 do i= 0,nx-1
    if (i .lt. 3600) then
       p = i + 3600
       xi(p) = x2(i) + 360.      
    else
       p = i - 3600
       xi(p) = x2(i)
    end if
    bi(:,p)= b2(:,i) 
 end do
;print (xi)
;print (yi)
;exit

 f     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
;f     = addfile ("i01.04casa_1605-1629_ANN_climo.nc","r")

 xo    = f->lon     
 yo    = f->lat      

 print (xi)
 print (yi)
 print (xo)
 print (yo)

 bo = linint2_Wrap(xi,yi,bi,True,xo,yo,0) 
 
 v = zonalAve(bo)

 v@long_name = "NPP (gC/m2/year)"
 
;************************************************
; plotting parameters
;************************************************
 wks   = gsn_open_wks ("png","xy")                ; open workstation

 res                  = True                     ; plot mods desired
 res@tiMainString     = "Observed T31"          ; add title

 plot  = gsn_csm_xy (wks,v&lat,v,res) 
end
