pro zonal_npp

cdfid=ncdf_open('npp_T42_mean_2000-2004.nc')
lon_dimid=ncdf_dimid(cdfid,'lon')
ncdf_diminq,cdfid,lon_dimid,lon_name,lon_size
lat_dimid=ncdf_dimid(cdfid,'lat')
ncdf_diminq,cdfid,lat_dimid,lat_name,lat_size
lon_varid=ncdf_varid(cdfid,'lon')
ncdf_varget,cdfid,lon_varid,lon
lat_varid=ncdf_varid(cdfid,'lat')
ncdf_varget,cdfid,lat_varid,lat
npp_varid=ncdf_varid(cdfid,'NPP')
ncdf_varget,cdfid,npp_varid,npp
ncdf_attget,cdfid,npp_varid,'long_name',long_name
ncdf_attget,cdfid,npp_varid,'_FillValue',missing_value
ncdf_attget,cdfid,npp_varid,'units',units
ncdf_close,cdfid

npp_zmean=fltarr(lat_size)
npp_zstddev=fltarr(lat_size)

for i=0,lat_size-1 do begin
   vdata = npp[*,i]
   idx = where(vdata ne missing_value,cnt)
   if cnt gt 0 then begin
      npp_zmean[i] = mean(vdata[where(vdata ne missing_value)])
   endif else begin
      npp_zmean[i] = 0.
   endelse
   if cnt gt 1 then begin
      npp_zstddev[i] = stddev(vdata[where(vdata ne missing_value)])
   endif else begin
      npp_zstddev[i] = 0.
   endelse
endfor

ofname='npp_T42_mean_2000-2004_zonal.dat'
openw,1,ofname
printf,1,'     Latitude ZonalMean_NPP   ZonalStdDev_NPP'
for i=0,lat_size-1 do begin
   printf,1,lat[i],npp_zmean[i],npp_zstddev[i]
endfor
close,1

return
end
